/*-------------------------------------*\
|   AVR SPI Color LCD Display			|
| Provides access to LCD				|
| using software SPI in assembly		|
| Adam Honse (CalcProgrammer1), 11/2010 |
\*-------------------------------------*/

#ifndef COLOR_LCD_H
#define COLOR_LCD_H

#include <avr/io.h>
#include <util/delay.h>

//soft_spi_init
// Initializes software SPI
void soft_spi_init();

//soft_spi_send_byte
// Outputs a 9-bit SPI value.
void soft_spi_send_byte(char cmd, char data);

//color_lcd_initialize
// Initializes the Nokia LCD connected
// to the soft SPI port
void color_lcd_initialize();

//color_lcd_set_pixel
// Sets a single pixel on the color LCD
void color_lcd_set_pixel(int color, unsigned char x, unsigned char y);

//color_lcd_draw_rectangle
// Draws a rectangle of color <color> from <xs>,<ys> to <xe>,<ye>
void color_lcd_draw_rectangle(int color, unsigned char xs, unsigned char ys, unsigned char xe, unsigned char ye);

//color_lcd_send_cmd
// Sends command <cmd> to the LCD
#define color_lcd_send_cmd(cmd)			soft_spi_send_byte(0, cmd)

//color_lcd_send_data
// Sends data <data> to the LCD
#define color_lcd_send_data(data)		soft_spi_send_byte(1, data)

//Command Table for Phillips Controller - See PCF8833 Datasheet for more information
//Commands must be issued with 9th bit cleared - use color_lcd_send_cmd with these defines
#define NOP			0x00		//No Operation
#define SWRESET		0x01		//Software Reset
#define BSTROFF		0x02		//Booster Voltage Off
#define BSTRON		0x03		//Booster Voltage On
#define RDDIDIF		0x04		//Read Display Identification
#define RDDST		0x09		//Read Display Status
#define SLEEPIN		0x10		//Enters Sleep Mode
#define SLEEPOUT	0x11		//Exits Sleep Mode
#define PTLON		0x12		//Partial Mode ON
#define NORON		0x13		//Normal Mode ON
#define INVOFF		0x20		//Display Inversion OFF
#define INVON		0x21		//Display Inversion ON
#define DAL0		0x22		//All Pixels OFF
#define DAL			0x23		//All Pixels ON
#define SETCON		0x25		//Set Contrast (byte Contrast - 7 bit contrast setting)
#define DISPOFF		0x28		//Display OFF
#define DISPON		0x29		//Display ON
#define CASET		0x2A		//Column Address Set [X address] (byte Start, byte End)
#define PASET		0x2B		//Page Address Set [Y address] (byte Start, byte End)
#define RAMWR		0x2C		//Memory Write [Send data after this command]
#define RGBSET		0x2D		//Color Set [See Datasheet for arguments]
#define PTLAR		0x30		//Partial Area (byte Start address, byte End address)
#define VSCRDEF		0x33		//Vertical Scroll Definition (byte top fixed area, byte bottom fixed area, byte scroll area)
#define TEOFF		0x34		//Tearing Line OFF
#define TEON		0x35		//Tearing Line ON
#define MADCTL		0x36		//Memory Data Access Control (1 byte) [Mirror Y, Mirror X, Vertical Write, Bottom to Top, BGR, X, X, X]
#define SEP			0x37		//Set Scroll Entry Point (byte Scroll Entry Point)
#define IDMOFF		0x38		//Idle Mode OFF
#define IDMON		0x39		//Idle Mode ON
#define COLMOD		0x3A		//Interface Pixel Format (byte Color Mode - See Datasheet for more information)
#define SETVOP		0xB0		//Set Vop (operating voltage) (byte Vop, byte Vop - See Datasheet for more information)

#endif
